org 100h   ; assume ax=bx=0 si=0x100 di=sp=-2

;68 f6 9f
  push 0xa000 - 160/16
  mov al,0x13
  lds bp,[si-3]; cx=0, ds=0x6800: table segment

;Palette: two gradients (red, orange)
P int 0x10     ; init: set 320x200 mode
  xor cx,cx
  shrd dx,bx,9
  jc Q
  xchg dl,ch
Q mov ax,0x1010; set palette color (bl=index): dh=R ch=G cl=B
  dec bx
  jnz P        ; bx=0

  fninit

;Sine table: 16384 float32 entries (-1..1)
S mov bx,[bp+di]    ; init: [bp+di]=[-2]=0
  fild word[bp+di]  ;| t
  fidiv word[byte bp+si-0x100+K]
  fsin              ;| sin(t/65536*2pi)
  fstp dword[bx]
  add [bp+di],sp    ; -4
  jnz S        ; bx=4

  pop es       ; es=0x9ff6: centered screen segment

M:
;For each pixel: find dX,dY,dZ and initialize X,Y,Z
;bx=time di=address si=0x3e28(not on init)
X mov ax,0xcccd
  mov cl,96    ; cl=dZ=0x60??
  mul di
  sub dh,cl    ; dh=dY (centered), dl=dX bx=T=time
  xchg ax,si   ; ax=X=0x3e28
;be 28 = 10430 ~ 65536/2pi
K mov si,0x3e28; si=0x3e28 (exact sin->cos phase is 0x4000)

  pusha        ; -9 -8 -7 -6 -5 -4 -3
               ; bh dl dh cl ch al ah
               ; ( dX )
               ;    ( dY )
               ;       ( dZ )

  cwd          ; dx=Y=0

Z:
;Compute the distance to the gyroid
G fld dword[bx+si]
  xchg ax,dx   ;| cosZ | cosY | cosX
  xchg ax,bx   ; ax=X dx=Y bx=Z -> ax=Z dx=X bx=Y
  fmul dword[bx]
  inc bp       ;| cosZ*sinY | cosY*sinX | cosX*sinZ
  jpo G        ; bp=3
  faddp
  faddp        ;| d=cosZ*sinY+cosY*sinX+cosX*sinZ
  fist word[bp-7]; pushed ax[-4] = round(d) (+1 or -1)
  fabs         ;| |d|
  fldl2e       ;| 1.442695 |d|
  fsubrp st1,st0;| D=1.442695-|d|

;  fsubr dword[bp+1+0x100]

;Advance ray
A:
  fild word[bp-10]
  fmul st1     ;| dZ*D D
  fistp dword[bp+si]
  xchg ax,dx
  xchg ax,bx   ; ax=X dx=Y bx=Z -> ax=Z dx=X bx=Y
  sar dword[bp+si],2  ; distance factor: 1/4
  add ax,[bp+si]; Y+=dY*D/4 | X+=dX*D/4 | Z+=dZ*D/4
  and al,0xfc  ; align to a multiple of 4 (for sintable)
  dec cx       ; cx-=3
  dec bp
  jpo A        ; bp=0

;  mov di,[bp-10]
;  sar di,3
;  xchg ax,dx
;  xchg ax,bx   ; ax=X dx=Y bx=Z -> ax=Z dx=X bx=Y
;  adc ax,di    ; Y+=dY*D/4 | X+=dX*D/4 | Z+=dZ*D/4
;  and al,0xfc  ; align to a multiple of 4 (for sintable)
;  dec bp
;  jpo A        ; bp=0

;Close enough?
  fstp dword[bp+si]

  cmp [bp+si+2],si
  jl D          ; hit if D<0.1640625 (= bits(D)<0x3e280000)
  loop Z        ; max 24 iterations
;  cmp byte[bp+si+3],0x3d
;  loopne Z      ; hit if 0.03125<=D<0.125 (= bits(D)==0x3d??????), max 24 iterations

;Texture and draw pixel
D 
;  mul dx
;  and dh,0xc
;  add cl,dh

;  mul word[bp-4]
;  and dh,0xc
;  add cl,dh

  and ah,0xc
  add cl,ah
  
  add [bp-4],cx  ; pushed ax[-4] += number of iterations
  inc di       ; set zero flag
  popa
  stosb        ; al=color
;  test di,di
  jnz X

;Next frame
  add bh,bl    ; time+=4
;  inc bh       ; time++

;  in al,0x60   ; esc check
;  dec ax
;  jnz M
;  ret
  jmp M

;c65536div2pi: dw 10430 ; 65536/2pi
;cDistFactor: dd 0.25   ; (0.75 (Lipchitz constant) / 44700 (avg dir length)) * 65536/2pi
;cOffset: dd 1.5

;; Palette test
;  push 0xa000
;  pop es
;  xor di,di
;  xor ax,ax
;Y stosb
;  inc al
;  jnz Y
;  add di,64
;  jns Y
;
;  xor ax,ax
;  int 0x16
;  ret
